//Experiment - 2
//Analyzing the effect of sampling of continuous time signal to avoid aliasing.

clear;
clc;
close;


// Aliasing

f = 60; // signal freq. in Hz
tmin = -0.05;
tmax = 0.05;
t = linspace(tmin, tmax, 400);
alpha = 1;
x_c = cos(alpha * 2 * %pi * f * t);
figure;
plot(t, x_c)

Fs = 200 // for 400, 200, 120, 70, 40 Hz

T = 1/Fs;
nmin = ceil(tmin/T);
nmax = floor(tmax/T);
n = nmin:nmax;
x_s = cos(2*%pi*f*n*T);
figure;
plot(t, x_c)
mtlb_hold("on")
plot(n*T, x_s, '.')
mtlb_hold("off")

figure;
plot(n*T, x_s, '-.');

//viewing spectrum of signals
t=soundsec(0.5);
s1=sin(2*%pi*60*t);// signal frequency=60Hz
s2=sin(2*%pi*200*t);// sampling frequency=200Hz
analyze(s1,10,600,22050)
analyze(s2,10,600,22050)
title('Spectrum of signals')

